# -*- coding: utf-8 -*-
"""
Created on Fri Feb 10 14:59:47 2023

@author: reinoutubbink
"""

import numpy as np
import matplotlib.pyplot as plt
import glob
import os

#constants needed for plotting

currents = []
voltages = []
scanrates = [0.1,0.15,0.2,0.3,0.4,0.6,0.8,1,1.5,2,3,4,6,8,10,15,20,30]


for filename in glob.glob('*.csv'):
   with open(os.path.join(os.getcwd(), filename), 'r') as f: # open in readonly mode
       curtemp = np.loadtxt(f, delimiter = '\t')
       currents.append(curtemp[:,1])
       voltages.append(curtemp[:,0])

       
voltage = curtemp[:,0]
Curnum = len(currents)
x = np.linspace(scanrates[0],scanrates[-1],Curnum)

J0 = []
for i in range(Curnum):
    J0.append(-min(currents[i]))
       

mobs = []
for i in range(Curnum):
    mobs.append(1.39e-11*(J0[i]/0.1)**2/scanrates[i]*38.68)

plt.close("all")
fig1 = plt.figure('scan rate vs maximum current')
ax1 = fig1.add_subplot(1,1,1)
plt.scatter(scanrates[:],J0,color='k', marker='o')
plt.plot(x,x/5000,'b--')
plt.plot(x,x**0.5/2000,'k--')
plt.yscale('log')
plt.xscale('log')
ax1.set_xlim([0.09,50])
ax1.set_ylim([1e-5,5e-3])
ax1.tick_params(length=7, width=2,labelsize='20')
ax1.margins(x=0.01,y=0.1)
fig = plt.gcf()
fig.set_size_inches(5, 3.5, forward=True)
plt.tight_layout()

figm = plt.figure('Mobilities')    
axm = figm.add_subplot(1,1,1)
plt.scatter(scanrates,mobs,s=100,color='white', marker='o',linewidths=2,edgecolors='k')
plt.xlabel('Scan rate (V/s)', size = '15')                              
plt.ylabel('Mobilities (m2V-1s-1)', size = '15')
plt.yscale('log')
plt.ylim([1e-16,1e-11])
axm.tick_params(which='major',length=8, width=2,labelsize='25')
figm.set_size_inches(10, 7, forward=True)
plt.show()

fig2 = plt.figure('CVs')
for i,current in enumerate(currents[:10]):
    plt.plot(voltages[i],current)